package com.youqian.api.dto.customer;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 商户的客户表
 * @author youqian mybatis generator 
 * 2020-03-31
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CustomerDto implements Serializable {
    private static final long serialVersionUID = 15856513457048043L;

    /**
     * 自增键
     * not null default = null
     */
    private Long id;

    /**
     * 客户ID
     * not null default = 0
     */
    private Long customerId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 账号，冗余PlatformUser表account字段
     * max length = 100
     * not null default = 
     */
    private String account;

    /**
     * 手机号码，冗余PlatformUser表mobile字段
     * max length = 20
     * not null default = 
     */
    private String mobile;

    /**
     * 客户名称，冗余platformUser表的userName字段
     * max length = 100
     * not null default = 
     */
    private String userName;

    /**
     * 头像，冗余platformUser表的avatar_url字段
     * max length = 100
     * not null default = 
     */
    private String avatarUrl;

    /**
     * 企业名称
     * max length = 64
     * not null default = 
     */
    private String enterpriseName;

    /**
     * 客户标签,标签表ID组，逗号隔开
     * max length = 60
     * not null default = 
     */
    private String tab;

    /**
     * 待收款金额
     * not null default = 0.00
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal restPrice;

    /**
     * 交易总金额
     * not null default = 0.00
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal totalPrice;

    /**
     * 开单次数
     * not null default = 0
     */
    private Integer createOrderCount;

    /**
     * 最近一次开单时间
     */
    private Date lastCreateOrderTime;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 主体id
     */
    private Long signEntityId;
}