package com.youqian.api.params.dunningbill;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.youqian.api.annotation.AutoId;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 * 回款单操作参数
 * Created by hong
 * time 2020/4/13.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DunningBillOperateParam {

    /**
     * 唯一id
     * not null default = null
     */
    private Long       dunningBillId;

    /**
     * 付款截至日期
     */
    private LocalDate  payDate;

    /**
     * 订单id集合
     */
    private List<Long> orderIds;

    /**
     * 客户id
     */
    private Long       customerId;

    /**
     * 订单回款单关联id(前端不需要)
     */
    @AutoId
    private Long       orderDunningBillRId;
}
