package com.youqian.api.params.shoptag;

import com.youqian.api.annotation.AutoId;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * 商品标签操作参数
 * Created by hong
 * time 2020/4/7.
 */
@Data
public class OperateGoodsTagParam {

    /**
     * 标签id
     */
    @AutoId
    private Long    id;

    /**
     * 标签名
     */
    @NotBlank
    @Size( max= 6,min = 1,message = "标签名应为1-6位")
    private String  name;

    /**
     * 显示排序
     */
    private Integer displayOrder;

    /**
     * 标签操作参数集合
     */
    List<GoodsTagRelationParam> Params;

    /**
     * 商品id
     */
    private Long  goodsId;
}
