package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;

@Getter
public enum WxVerifyLoginEnum {
    /**
     * 小程序OpenId的区分
     */
    YQ_MIN_OPENID("yq_min_openId","有签的小程序OpenId","wx_min_open_id"),
    YQ_SUB_OPEN_ID("yq_sub_openId","有签公众号的OpenId","wx_sub_open_id"),
    STDIO_MIN_OPEN_ID("stdio_min_openId","直播小程序的OpenId","wx_studio_min_open_id");

    private String code;
    private String msg;
    private String tableField;

    WxVerifyLoginEnum(String code, String msg, String tableField) {
        this.code = code;
        this.msg  = msg;
        this.tableField = tableField;
    }

    public static WxVerifyLoginEnum get(String code){
        for(WxVerifyLoginEnum wxVerifyItem:values()){
            if(Objects.equals(wxVerifyItem.getCode(),code)){
                return wxVerifyItem;
            }
        }
        return null;
    }
}
