package com.youqian.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/3/31.
 */
@Getter
public enum SortTypeEnum {
    ASC(1,"asc","倒序"),

    DESC(0,"desc","正序");

    private final Integer code;

    private final String type;

    private final String desc;

    SortTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static SortTypeEnum getByCode(Integer code){
        return Stream.of(SortTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(ASC);
    }

    public static SortTypeEnum getByType(String type){
        return Stream.of(SortTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(ASC);
    }
}
