package com.youqian.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.dto.customer.CustomerDto;
import com.youqian.api.params.customer.CustomerAddParam;
import com.youqian.api.params.customer.CustomerParam;
import com.youqian.api.params.customer.CustomerLiveAddParam;
import com.youqian.api.params.customer.SelectCustomerParam;
import com.youqian.api.request.Customer;
import com.youqian.auth.api.exception.BizException;

import java.util.Collection;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/21
 * @description
 */
@AdvancedFeignClient
public interface RemoteCustomerService {

    /**
     * 批量查询客户
     *
     * @param customerIds 客户ID
     * @return List<CustomerDto>
     */
    List<CustomerDto> batchGet(Collection<Long> customerIds) throws BizException;

    /**
     * 判定是否黑名单
     *
     * @param selectCustomerParam 查询参数
     */
    CustomerDto getInfo(SelectCustomerParam selectCustomerParam) throws BizException;

    /**
     * 展示客户列表
     */
    List<CustomerDto> customerInfoList(CustomerParam customerParam) throws BizException;

    /**
     * 展示客户列表
     */
    Integer countCustomerInfo(CustomerParam customerParam) throws BizException;

    /**
     * 新增客户
     * @param customerAddParam 客户操作参数
     */
    CustomerDto addCustomer(CustomerAddParam customerAddParam);

    /**
     * 批量新增客户
     * @return
     */
    Boolean batchAddCustomer(Long merchantId,List<Customer> customers);
    /**
    * 直播申请新增客户
     * @param customerLiveAddParam 客户操作参数
     */
    CustomerDto addLiveCustomer(CustomerLiveAddParam customerLiveAddParam);
}
