package com.youqian.api.request;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播中商品信息
 * @author xiachenhang
 */
@Data
public class LiveInfoDataRequest implements Serializable {
    /**
     * 直播间ID
     */
    private Long liveRoomId;
    /**
     * 直播统计ID
     */
    private Long liveReportStatisticalId;
    /**
     * 直播间是否结束
     */
    private Byte hasFinish;
    /**
     * 直播开始时间
     */
    private Date beginTime;
    /**
     * 直播结束时间：若未结束则当前时间
     */
    private Date endTime;
    /**
     * 商户ID
     */
    private Long merchantId;
    /**
     * 直播时长
     */
    private Long liveTime;
    /**
     * 观看PV
     */
    private Integer watchPv = 0;
    /**
     * 观看UV
     */
    private Integer watchUv = 0;
    /**
     * 商品数
     */
    private Integer liveGoodsTotal;
    /**
     * 人均观看时长
     */
    private String watchTimeAverage;
    /**
     * 最高在线人数
     */
    private Integer watchHighestUv;
    /**
     * 到场率
     */
    private String watchInviteRatio;
    /**
     * 订阅到场率
     */
    private String watchSubscribeRatio;
    /**
     * 互动人数，评论+红包+抽奖
     * not null default = 0
     */
    private Integer interaction = 0;

    /**
     * 抽奖人数
     * not null default = 0
     */
    private Integer raffle = 0;

    /**
     * 红包人数
     * not null default = 0
     */
    private Integer redPacket = 0;

    /**
     * 评论人数
     * not null default = 0
     */
    private Integer liveComment = 0;

    /**
     * 累计评论数
     */
    private Integer commentTotal;

}
