package com.youqian.api.dto.redpack.custom;

import com.youqian.api.dto.redpack.RedpackParticipationDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by hong
 * time 2020/7/17.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ParticipationBillDto extends RedpackParticipationDto {

    private static final long serialVersionUID = -1239083583310980422L;

    /**
     * 红包流水id
     */
    private Long redpackBillId;

    /**
     * 领取时间
     */
    private Date receiveTime;

    /**
     * 订单号
     * max length = 25
     * not null default = null
     */
    private String bizTradeNo;

    /**
     * 申请商户号的appid或商户号绑定的appid
     * max length = 128
     * not null default = null
     */
    private String appId;

    /**
     * 用户的标识，对公众号唯一
     * max length = 128
     * not null default = null
     */
    private String openId;

    /**
     * 用户真实ip
     * max length = 32
     * not null default = null
     */
    private String clientIp;

    /**
     * 错误码信息
     * max length = 64
     * not null default =
     */
    private String errCode;

    /**
     * 失败码信息
     * not null default = 0
     */
    private String errCodeDes;

    /**
     * 收入或支出 1收入 2支出
     * not null default = 1
     */
    private Byte incomeOrExpenses;

    /**
     * 备注
     * max length = 255
     * not null default =
     */
    private String billRemark;

    /**
     * 红包详情
     * max length = 255
     * not null default =
     */
    private String billDetail;

    /**
     * 发放后红包余额
     * not null default = 0.0000
     */
    private BigDecimal balance;

    /**
     * 商户id
     * not null default = 0
     */
    private Long merchantId;

}
