package com.youqian.api.params.user;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class UserTwoAuthParam {

    @NotBlank
    @ApiModelProperty(value = "身份证", required = true)
    private String idCard;

    @NotBlank
    @ApiModelProperty(value = "姓名", required = true)
    private String name;

    @NotBlank(message = "请上传正面照片")
    @ApiModelProperty(value = "正面照文件ID-识别会返回",required = true)
    private String frontFileId;

    @NotBlank
    @ApiModelProperty(value = "反面照文件ID-识别会返回",required = true)
    private String backFileId;

}
