package com.youqian.api.dto.merchant;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 商户店铺的相册
 * @author youqian mybatis generator 
 * 2020-04-01
 */
@Data
public class merchantAlbumDto implements Serializable {
    private static final long serialVersionUID = 15857127725186713L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 商户图片ID
     * not null default = 0
     */
    private Long merchantAlbumId;

    /**
     * 商户店铺ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 相册名
     * max length = 20
     * not null default = 
     */
    private String name;

    /**
     * 图片总数
     * max length = 10
     * not null default = 0
     */
    private String imageNum;

    /**
     * 删除标识
     * not null default = 0
     */
    private Byte deleteFlag;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}