package com.youqian.api.dto.redpack.custom;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by hong
 * time 2020/7/23.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RedpackSaveMqDto implements Serializable {

    private static final long serialVersionUID = 2706115773583934871L;

    /**
     * 抢红包用户
     * not null default = 0
     */
    private Long userId;

    /**
     * 参与红包id
     * not null default = 0
     */
    private Long redpackId;

    /**
     * 抢到红包金额
     * not null default = 0.0000
     */
    private BigDecimal amount;

    /**
     * 领取类型：1-普通红包，2-手气王
     * not null default = 0.0000
     */
    private Byte receiveType;


    /**
     * 用户名称 冗余 platform_user
     * max length = 100
     * not null default =
     */
    private String userName;

    /**
     * 头像 冗余 platform_user
     * max length = 300
     * not null default =
     */
    private String avatarUrl;

    /**
     * 抢红包时间
     */
    private Date grabDate;


    /**
     * 用户真实ip
     * max length = 32
     * not null default = null
     */
    private String clientIp;

    /**
     * 余额
     */
    private BigDecimal balance;
}
