package com.youqian.api.dto.shopgoods;

import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 商品询价
 * @author youqian mybatis generator 
 * 2020-04-20
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ShopGoodsPictureEnquiryDto implements Serializable {
    private static final long serialVersionUID = 15873523105689244L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long shopGoodsPictureEnquiryId;

    /**
     * 商品id
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 商户id
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;
}