package com.youqian.api.dto.shopgoods;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 规格属性名表
 * @author youqian mybatis generator 
 * 2020-06-11
 */
@Data
public class ShopSpecParamDto implements Serializable {
    private static final long serialVersionUID = 15918567972108882L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long shopSpecParamId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 规格属性名
     * max length = 30
     * not null default = null
     */
    private String name;

    /**
     * 显示排序
     * not null default = 0
     */
    private Long displayOrder;

    /**
     * 是否必选  1必选
     * not null default = 0
     */
    private Byte required;

    /**
     * 是否多选 1多选
     * not null default = 0
     */
    private Byte multi;

    /**
     * 是否颜色属性  1是
     * not null default = 0
     */
    private Byte color;

    /**
     * 是否枚举属性  1是
     * not null default = 0
     */
    private Byte enumeration;

    /**
     * 是否填写属性  1是
     * not null default = 0
     */
    private Byte input;

    /**
     * 是否关键属性  1是
ps：
能够确认唯一"产品"的属性，可以是一个，或者多个关键属性的组合。如：手机的"品牌""型号"能确定唯一的产品，服装的"品牌""货号"能确定唯一的产品
     * not null default = 0
     */
    private Byte crux;

    /**
     * 是否销售属性  1是
ps：
组成SKU的特殊属性，它会影响买家的购买和卖家的库存管理，如服装的"颜色"、"套餐"和"尺码"

     * not null default = 0
     */
    private Byte sale;

    /**
     * 服装商场的特殊需求，只要颜色和尺寸
1代表颜色属性
2代表尺寸属性
0代表其他属性
     * not null default = 0
     */
    private Byte colorOrSize;

    /**
     * 商户号
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 商品id
     * not null default = 0
     */
    private Long goodsId;
}