package com.youqian.api.dto.wallet;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 钱包流水表
 * @author youqian mybatis generator 
 * 2020-07-15
 */
@Data
public class WalleBilltDto implements Serializable {
    private static final long serialVersionUID = 15948067537768125L;


    /**
     * 唯一id
     * not null default = null
     */
    private Long walletBillId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 收入或支出 1收入 2支出
     * not null default = 1
     */
    private Byte incomeOrExpenses;

    /**
     * 收入或支出金额
     * not null default = 0.0000
     */
    private BigDecimal amount;

    /**
     * 员工id 暂时充值用
     * not null default = 0
     */
    private Long employeeId;

    /**
     * 用户id
     * not null default = 0
     */
    private Long userId;

    /**
     * 备注
     * max length = 255
     * not null default =
     */
    private String billRemark;

    /**
     * 收支原因
     * max length = 255
     * not null default =
     */
    private String billReason;

    /**
     * 收支详情
     * max length = 255
     * not null default =
     */
    private String billDetail;

    /**
     * 收支后余额
     * not null default = 0.0000
     */
    private BigDecimal balance;

    /**
     * 商户id
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 类型
     * not null default = 0
     */
    private Integer billType;

    /**
     * 类型所对应表的id
     * not null default = 0
     */
    private Long typeId;
    /**
     * 钱包id
     * not null default = null
     */
    private Long walletId;

    /**
     * 订单号
     */
    private String bizTradeNo;

    /**
     * 用户的标识，对公众号唯一
     */
    private String openId;

    /**
     * 流水状态 0待处理 1成功 2失败
     */
    private Byte billStatus;

    /**
     * 申请商户号的appid或商户号绑定的appid
     */
    private String appId;

    /**
     * 用户真实ip
     */
    private String clientIp;

    /**
     * 错误码
     */
    private String errCode;

    /**
     * 错误码信息
     */
    private String errCodeDes;
}