package com.youqian.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/8/14.
 */
@Getter
public enum CompanyLevelEnum {

    HEAD(1,"head","总公司"),
    BRANCH(2,"branch","分公司");

    private final Integer code;

    private final String type;

    private final String desc;

    CompanyLevelEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static CompanyLevelEnum getByCode(Integer code) {
        return Stream.of(CompanyLevelEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(HEAD);
    }

    public static CompanyLevelEnum getByType(String type) {
        return Stream.of(CompanyLevelEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(HEAD);
    }
}

