package com.youqian.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/4/9.
 */
@Getter
public enum DeletedEnum {
    DELETE((byte)1,"delete","删除"),
    NOT_DELETED((byte)0,"not_delted","未删除")
    ;

    private final Byte code;

    private final String type;

    private final String desc;

    DeletedEnum(Byte code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static DeletedEnum getByCode(Byte code) {
        return Stream.of(DeletedEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(NOT_DELETED);
    }

    public static DeletedEnum getByType(String type) {
        return Stream.of(DeletedEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(NOT_DELETED);
    }
}
