package com.youqian.api.remoteservice;

import com.youqian.api.dto.platformuser.PlatformUserDto;
import com.youqian.api.request.UserListRequest;
import com.youqian.auth.api.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.request.TokenVRequest;
import com.youqian.api.response.PlatformUserResponse;

import java.util.List;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description
 */
@AdvancedFeignClient
public interface RemoteUserService {

    /**
     * 根据openId获取用户信息
     *
     * @param tokenRequest openId&type
     * @return PlatformUser
     * @throws BizException 用户不存在
     */
    PlatformUserResponse getUserByOpenId(TokenVRequest tokenRequest) throws BizException;

    /**
     * 定时任务处理accessLog的停留时间
     * @throws BizException
     */
    void accessLogJob() throws BizException;

    /**
     * 根据UserId获取用户信息
     *
     * @param userId userId
     * @return PlatformUserDto
     * @throws BizException 用户不存在
     */
    PlatformUserDto getByUserId(Long userId) throws BizException;
    /**
     * 根据UserId组获取用户信息
     *
     * @param userIds userId组
     * @return PlatformUserDto
     * @throws BizException 用户不存在
     */
    List<PlatformUserDto> getByUserIds(List<Long> userIds) throws BizException;

    /**
     * 根据用户ID 查找列表
     *  @param userListRequest 列表参数
     *  @return
     */
    List<PlatformUserDto> selectByUserList(UserListRequest userListRequest);

    /**
     * 根据用户ID 统计
     *  @param userListRequest 列表参数
     *  @return
     */
    Integer countUserList(UserListRequest userListRequest);

}
