package com.youqian.api.request;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户收货地址表
 * @author youqian mybatis generator
 * 2020-04-08
 */
@Data
public class UserAddressResult implements Serializable {
    private static final long serialVersionUID = 3905804449743079001L;
    /**
     * 用户地址ID
     * not null default = 0
     */
    private Long userAddressId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 收货人名称
     * max length = 20
     * not null default =
     */
    private String name;

    /**
     * 收货人手机号码
     * max length = 20
     * not null default =
     */
    private String mobile;

    /**
     * 收货地址
     * max length = 200
     * not null default =
     */
    private String address;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 区
     */
    private String area;

    /**
     * 是否默认: 0-不默认 1-默认
     */
    private Byte hasDefault;

    /**
     * 地址简称
     */
    private String shortAddress;
}
