package com.youqian.api.response;

import com.youqian.api.request.PageRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description 分页结果
 */
@Data
public class PageResult<T> implements Serializable {

    private static final long serialVersionUID = 3500044282124584159L;

    @ApiModelProperty("分页数据")
    private List<T> list;

    @ApiModelProperty("页码")
    private Integer pageNo;

    @ApiModelProperty("页大小")
    private Integer pageSize;

    @ApiModelProperty("是否有下一页")
    private Boolean hasNext;

    @ApiModelProperty("总共条数")
    private Long total = 0L;

    @ApiModelProperty("总页数")
    private Integer totalPageNo = 0;

    public static <T> PageResult<T> create(List<T> data, Integer pageNo, Integer pageSize, Long total) {
        PageResult<T> pageResult = new PageResult<>();
        pageResult.setList(data);
        pageResult.setPageNo(pageNo);
        pageResult.setPageSize(pageSize);
        pageResult.setTotal(total);
        if (CollectionUtils.isEmpty(data)) {
            pageResult.setHasNext(false);
        } else {
            if (pageSize > data.size()) {
                pageResult.setHasNext(false);
            } else {
                pageResult.setHasNext(true);
            }
        }
        long totalPageNo = (total % pageSize == 0) ? total / pageSize : (total / pageSize + 1);
        pageResult.setTotalPageNo((int) totalPageNo);
        return pageResult;
    }

    public static <T> PageResult<T> create(List<T> data, PageRequest pageRequest, Long total) {
        return create(data, pageRequest.getPageNo(), pageRequest.getPageSize(), total);
    }
}
