package com.youqian.api.dto.customer.custom;

import com.youqian.api.dto.PageDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 客户画像客户地区分布
 * 泛型（每个地区的客户数据）
 * Created by hong
 * time 2020/8/18.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerAreaDto extends PageDto<AreaCustomerCountDto> {

    private static final long serialVersionUID = 7174462054728818192L;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * x轴值
     */
    private List<Integer> xAxisValue;

    /**
     * 存在省份数组
     */
    private List<String> provinces;

    public static CustomerAreaDto createDto(List<AreaCustomerCountDto> list, int pageNo, int pageSize, int totalSize) {
        CustomerAreaDto pageDto = new CustomerAreaDto();
        pageDto.setList(list);
        pageDto.setPageNo(pageNo);
        pageDto.setPageSize(pageSize);
        pageDto.setTotalSize(totalSize);
        pageDto.setHasNext(list.size() == pageSize&&pageNo*pageSize!=totalSize);
        int totalPage = (totalSize % pageSize == 0) ? totalSize / pageSize : (totalSize / pageSize + 1);
        pageDto.setTotalPages(totalPage);
        return pageDto;
    }
}
