package com.youqian.api.dto.dunningbill;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import lombok.Data;

/**
 * 回款单表
 * @author youqian mybatis generator 
 * 2020-04-11
 */
@Data
public class DunningBillDto implements Serializable {
    private static final long serialVersionUID = 15865707192152525L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long dunningBillId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 客户id
     * not null default = 0
     */
    private Long customerId;

    /**
     * 付款截至日期
     * not null default = null
     */
    private LocalDate payDate;

    /**
     * 订单数量
     * not null default = 0
     */
    private Integer orderCount;

    /**
     * 未结清订单数
     * not null default = 0
     */
    private Integer unclearedOrderCount;

    /**
     * 客户用户名称
     * max length = 100
     * not null default = 
     */
    private String userName;

    /**
     * 头像，冗余platformUser表的avatar_url字段
     * max length = 100
     */
    private String avatarUrl;

    /**
     * 商户名称
     * max length = 64
     * not null default = 
     */
    private String enterpriseName;

    /**
     * 未结清金额
     * not null default = null
     */
    private BigDecimal pendingPayPrice;

    /**
     * 已付金额
     * not null default = null
     */
    private BigDecimal payPrice;

    /**
     * 商户用户id
     * not null default = null
     */
    private Long userId;

    /**
     * 商户id
     * not null default = null
     */
    private Long merchantId;
}