package com.youqian.api.dto.dunningbill.custom;

import com.youqian.api.dto.dunningbill.DunningBillDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * Created by hong
 * time 2020/4/15.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BillInfoDto extends DunningBillDto {

    private static final long       serialVersionUID = -1478307243339415600L;

    /**
     * 剩余待收款
     */
    private              BigDecimal remainingPayment;

    /**
     * 已完成数量
     */
    private              Integer    numberCompleted;

    /**
     * 创建时间距今（天数）
     */
    private              String    timeSinceCreation;

    /**
     * 是否已结清
     */
    private              Integer   whetherToSettle;
}
