package com.youqian.api.dto.raffle;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @author youqian mybatis generator 
 * 2020-07-06
 */
@Data
public class RaffleDto implements Serializable {
    private static final long serialVersionUID = 15940216461884856L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long raffleId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 奖品名称
     * max length = 20
     * not null default = 
     */
    private String prizeName;

    /**
     * 中奖人数
     * not null default = 0
     */
    private Integer winnersNumber;

    /**
     * 参与口令
     * max length = 20
     * not null default = 
     */
    private String word;

    /**
     * 抽奖持续时长
     * not null default = null
     */
    private Integer lotteryDuration;

    /**
     * 是否关注后参与
     * not null default = null
     */
    private Byte followAfterRaffle;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 商户id
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 开奖状态 0开奖中 1已开奖  2已取消
     * not null default = 0
     */
    private Byte status;

    /**
     * 直播id
     * not null default = null
     */
    private Long liveId;
}