package com.youqian.api.dto.reportmain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.youqian.api.response.GoodsColorResult;
import com.youqian.api.response.GoodsImageResult;
import lombok.Data;

/**
 * 报价商品表
 * @author youqian mybatis generator 
 * 2020-06-11
 */
@Data
public class OrderReportBillDto implements Serializable {
    private static final long serialVersionUID = 15918428791175557L;

    /**
     * 自增键ID
     * not null default = null
     */
    private Long id;

    /**
     * 报价ID
     * not null default = 0
     */
    private Long orderReportBillId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 商品名字
     * not null default = 0
     */
    private String goodsName;

    /**
     * 商品图片oss
     * not null default = 0
     */
    private String goodsThumb;

    /**
     * 商品ID
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 总数量
     * not null default = 0
     */
    private Integer goodsNum;
    /**
     * 商品款数
     */
    private Integer goodsCount;

    /**
     * 删除标识
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 商品规格详情
     */
    private List<GoodsColorResult> colorResultList;

    /**
     * 款号
     */
    private String shortName;

    /**
     * 商品状态
     */
    private Byte status;

    /**
     * 商品状态名
     */
    private String statusName;

    /**
     * 商品价格
     */
    private String price;

}