package com.youqian.api.dto.shopgoods.custom;

import com.youqian.api.dto.shopgoods.ShopGoodsDto;
import com.youqian.api.dto.shopgoods.ShopGoodsPictureDto;
import com.youqian.api.dto.shopgoods.ShopGoodsSkuDto;
import com.youqian.api.dto.shopgoods.ShopGoodsTagDto;
import com.youqian.api.dto.shopgoods.custom.picture.GoodsInfoPicDto;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 商品各类信息集合dto
 * Created by hong
 * time 2020/4/9.
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class GoodsWholeInfo extends ShopGoodsDto {

    private static final long serialVersionUID = -9170822282938047394L;

    /**
     * 商品图片集合
     */
    private List<GoodsInfoPicDto>     shopGoodsPictureDtos;

    /**
     * 商品规格集合
     */
    private List<ShopGoodsSkuDto>     shopGoodsSkuDtos;

    /**
     * 商品标签集合
     */
    private List<ShopGoodsTagDto>     shopGoodsTagDtos;

    /**
     * 是否收藏
     */
    private Boolean collect;
    /**
     * 是否询价
     */
    private Boolean enquiry;

    /**
     * 商户名称
     */
    private String merchantName;

    /**
     * 直播间讲解中状态
     */
    private Byte inIntroduced;
}
