package com.youqian.api.enums;

import lombok.Getter;

/**
 * 动作标签
 * @author xiachenhang
 */
@Getter
public enum ActionTagMsgEnum {
    TAG_DEPTH_1("深度访问","今日已访问%s次","单自然日累计访问次数达3次"),
    TAG_DEPTH_2("深度访问","今日已访问%s","单自然日累计访问时长达10分钟，为0时，不显示时长单位。3小时23秒，13分2秒"),
    TAG_DEPTH_3("深度访问","本次访问%s","单次访问时长达5分钟"),
    TAG_FIRST("新访客","","首次访问卖家任何页面"),
    TAG_FANS_1("获得粉丝","来自%s的直播","通过直播关注店铺"),
    TAG_FANS_2("获得粉丝","来自名片","通过其他途径关注店铺"),
    TAG_POTENTIAL_1("意向客户","来自%s的直播","在直播间询价/收藏商品。"),
    TAG_POTENTIAL_2("意向客户","来自名片","在名片页商品相册点击大图查看时询价，收藏。"),
    TAG_POTENTIAL_3("意向客户","来自%s的相册分享","通过了商品相册分享，询价/收藏了商品"),
    ;
    private String tag;
    private String message;
    private String condition;

    ActionTagMsgEnum(String tag,String message,String condition){
        this.tag = "#" + tag;
        this.message = message;
        this.condition = condition;
    }

    public String join(Object... data){
        return String.format(message,data);
    }
}
