package com.youqian.api.enums;

import com.google.common.base.Objects;
import lombok.Getter;

/**
 * @author xiachenhang
 */
@Getter
public enum EmployeeRoleEnum {
    /**
     * 用户身份
     */
    UN_KNOW((byte)-1,"未知"),
    EMPLOYEE((byte)0,"员工"),
    MANAGER((byte)1,"管理员"),
    ;

    private byte code;
    private String msg;

    EmployeeRoleEnum(byte code,String msg){
        this.code = code;
        this.msg  = msg;
    }

    public static EmployeeRoleEnum get(byte code){
        for(EmployeeRoleEnum e:values()){
            if(Objects.equal(code,e.getCode())){
                return e;
            }
        }
        return UN_KNOW;
    }

    public static boolean isManager(Byte code) {
        return Objects.equal(MANAGER.code, code);
    }
}
