package com.youqian.api.enums;

import lombok.Getter;

/**
 * @author tengtuox
 * @date 2020/3/30
 * @description 送货类型
 */
@Getter
public enum EnumTransType {

    UNKNOWN((byte) 0, "未知"),
    Delivery_Home((byte) 1, "卖方送货上门"),
    Self_Get((byte) 2, "买家自提"),
    ;

    private Byte code;

    /**
     * 送货描述
     */
    private String desc;

    EnumTransType(Byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }


}
