package com.youqian.api.enums;

import lombok.Getter;

/**
 * 小程序登录返回枚举
 */
@Getter
public enum MinLoginResultEnum {
    BUSY(-1,"系统繁忙,此时请开发者稍后再试"),
    SUCCESS(0,"请求成功"),
    INVALID(40029,"code无效"),
    LIMIT(45011,"频率限制,每个用户每分钟100次");

    private Integer code;

    private String description;

    MinLoginResultEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public static String getMessage(Integer code){
        for(MinLoginResultEnum minLoginResultEnum : MinLoginResultEnum.values()){
            if(minLoginResultEnum.getCode().equals(code)){
                return minLoginResultEnum.getDescription();
            }
        }
        return INVALID.getDescription();
    }

}
