package com.youqian.api.enums;

import lombok.Getter;

/**
 * 订货单状态
 * @author xiachenhang
 */
@Getter
public enum OrderReportStatusEnum {
    /**
     *
     */
    UN_KNOW((byte)-1,"未知",""),
    BUYER_ASK((byte)0,"买家询价","等待卖家报价"),
    SELL_REPEAT((byte)1,"卖家报价","等待买家确认"),
    BUYER_CONFIRM((byte)2,"买家确认","已确认"),
    CANCEL((byte)3,"取消","已确认"),
    ;

    private byte code;
    private String msg;
    private String desc;

    OrderReportStatusEnum(byte code,String msg,String desc){
        this(code,msg);
        this.desc = desc;
    }

    OrderReportStatusEnum(byte code,String msg){
        this.code = code;
        this.msg = msg;
    }

    public static OrderReportStatusEnum get(byte code){
        for(OrderReportStatusEnum s:values()){
            if(s.getCode() == code){
                return s;
            }
        }
        return UN_KNOW;
    }
}
