package com.youqian.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/8/1.
 */
@Getter
public enum WalletBillStatusEnum {

    PENDING((byte)0,"pending","待处理"),
    SUCCESS((byte)1,"success","成功"),
    FAIL((byte)2,"fail","失败");

    private final Byte code;

    private final String type;

    private final String desc;

    WalletBillStatusEnum(Byte code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static WalletBillStatusEnum getByCode(Byte code) {
        return Stream.of(WalletBillStatusEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(PENDING);
    }

    public static WalletBillStatusEnum getByType(String type) {
        return Stream.of(WalletBillStatusEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(PENDING);
    }
}

