package com.youqian.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * 账单类型
 * Created by hong
 * time 2020/7/23.
 */
@Getter
public enum WalletBillTypeEnum {

    REDPACK_TOP_UP(1,"redpackTopUp","红包充值"),
    REDPACK_SEND(2,"redpackSend","发红包"),
    REDPACK_RETURN(3,"redpack_return","发送红包失败退回"),
    REDPACK_TOP_UP_HANDLING_FEE(4,"redpackTopUpHandlingFee","红包充值手续费"),
    END_REDPACK_RETURN(5,"endRedpackReturn","取消红包退回"),
    NEXT_DAY_REIMBURSE(6,"endRedpackReturn","付款到个人超限隔日退款统一退款"),;

    private final Integer code;

    private final String type;

    private final String desc;

    WalletBillTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static WalletBillTypeEnum getByCode(Integer code) {
        return Stream.of(WalletBillTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(REDPACK_TOP_UP);
    }

    public static WalletBillTypeEnum getByType(String type) {
        return Stream.of(WalletBillTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(REDPACK_TOP_UP);
    }
}

