package com.youqian.api.enums.customer;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/8/15.
 */
@Getter
public enum SortPropertyEnumV1 {

    CREATE_TIME(0,"createTime",",新访客优先"),
    RECENT_INTERACTION_TIME(1,"recentInteractionTime","最近互动优先"),
    INTERACTIONS_TOTAL(2,"interactionsTotal","互动次数优先"),
    ;

    private final Integer code;

    private final String type;

    private final String desc;

    SortPropertyEnumV1(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static SortPropertyEnumV1 getByCode(Integer code) {
        return Stream.of(SortPropertyEnumV1.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(CREATE_TIME);
    }

    public static SortPropertyEnumV1 getByType(String type) {
        return Stream.of(SortPropertyEnumV1.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(CREATE_TIME);
    }
}

