package com.youqian.api.params.customer;

import cn.com.duiba.wolf.utils.DateUtils;
import lombok.Data;

import java.util.Date;
import java.util.Objects;

/**
 * 客户画像中性别分布的请求参数
 * Created by hong
 * time 2020/8/17.
 */
@Data
public class CustomerGenderParam {
    /**
     * 查询时间 0全部 1近7日  2近30日
     */
    private Integer queryTimeType;

    /**
     * 开始时间（自动计算）
     */
    private Date startTime;

    /**
     * 结束时间（自动计算）
     */
    private Date endTime;

    public void setQueryTimeType(Integer queryTimeType) {
        Date date = new Date();
        if(Objects.equals(queryTimeType, 1)){
            endTime= DateUtils.getDayEndTime(date);
            startTime = DateUtils.getDayStartTime(DateUtils.daysAddOrSub(date, -7));
        }else if(Objects.equals(queryTimeType,2)){
            endTime=DateUtils.getDayEndTime(date);
            startTime = DateUtils.getDayStartTime(DateUtils.daysAddOrSub(date, -30));
        }
        this.queryTimeType = queryTimeType;
    }

    /**
     * 商户id
     */
    private Long    merchantId;
}
