package com.youqian.api.params.merchant;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/1/17
 * @description
 */
@Data
public class ApplyEntCertParam implements Serializable {

    private static final long serialVersionUID = 6855338582174543231L;

    @NotBlank(message = "企业名称不能为空")
    @ApiModelProperty(value = "企业名称", required = true)
    private String entName;

    @NotBlank(message = "手机号不能为空")
    @ApiModelProperty(value = "法人手机号", required = true)
    private String legalMobile;

    @NotBlank(message = "法人名称不能为空")
    @ApiModelProperty(value = "法人名称", required = true)
    private String legalPerson;

    @NotBlank(message = "验证码不能为空")
    @ApiModelProperty(value = "短信验证码", required = true)
    private String messageCode;

}
