package com.youqian.api.params.merchant;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * @author xiachenhang
 */
@Data
public class MerchantStoreBossParam {

    @ApiModelProperty("老板名字")
    @NotBlank(message = "请输入老板名称")
    @Size(max = 10, min = 2, message = "名字长度要在2-20之间")
    private String bossName;

    @ApiModelProperty("老板职位")
    @Size(max = 10, min = 2, message = "职位长度要在2-20之间")
    private String bossTitle;

    @NotBlank(message = "老板头像未上传")
    @ApiModelProperty("老板头像-上传图片接口返回的ID")
    private String bossImageFileId;

    @ApiModelProperty("老板音频")
    private String bossVoice;

    @ApiModelProperty("老板寄语")
    @Size(max = 100, min = 0, message = "寄语长度要在1-100之间")
    private String bossWishes;

    private String duration;

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("缩略地址")
    private String simpleAddress;
}
