package com.youqian.api.params.shoptag;

import com.youqian.uid.annotation.AutoId;
import lombok.Data;

import java.io.Serializable;

/**
 * 商品和标签的关系参数表
 * (商品id与便签id二选一)
 * Created by hong
 * time 2020/4/8.
 */
@Data
public class GoodsTagRelationParam implements Serializable {

    private static final long serialVersionUID = 5210542541861003115L;

    /**
     * 商品标签关系id
     */
    @AutoId
    @Deprecated
    private Long shopGoodsTagRId;

    /**
     * 标签id(与商品id互斥)
     */
    private Long tagId;

    /**
     * 商品id(与标签id互斥)
     */
    private Long shopGoodsId;

}
