package com.youqian.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.request.OrderListRequest;
import com.youqian.api.response.OrderDetail;
import com.youqian.api.response.OrderMainListResult;
import com.youqian.auth.api.exception.BizException;

import java.util.List;

/**
 * Created by hong
 * time 2020/5/11.
 */
@AdvancedFeignClient
public interface RemoteOrderService {
    /**
     * 查询订单列表-后台管理
     */
    List<OrderMainListResult> orderList(OrderListRequest orderListRequest) throws BizException;
    /**
     * 订单统计-后台管理
     */
    Integer orderCount(OrderListRequest orderListRequest) throws BizException;

    /**
     * 订单详情-后台管理
     */
    OrderDetail getOrderDetail(Long orderId) throws BizException;
}
