package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class ConfirmBillV1Request {

    @Min(1)
    @NotNull(message = "订货单ID不能为空")
    @ApiModelProperty("订货单ID")
    private Long orderReportMainId;

    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date watchTime;

    @NotNull(message = "地址ID不能为空")
    private Long userAddressId;
}
