package com.youqian.api.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author tengtuox
 * @date 2020/3/26
 * @description
 */
@Data
public class StoreReportResult implements Serializable {

    @ApiModelProperty("今日开单")
    private Integer billingToday = 0;

    @ApiModelProperty("今日营业额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal turnoverToday = BigDecimal.ZERO;

    @ApiModelProperty("今日收款")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal collectBillToday = BigDecimal.ZERO;

    @ApiModelProperty("总应收款")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal allPriceDue = BigDecimal.ZERO;

}
