package com.youqian.api.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * 数据库订单状态
 */
@Getter
public enum EnumOrderStatus {
    UNKNOWN((byte) -1, "未知"),
    DRAFT((byte) 0, "草稿"),
    WAIT_CONFIRM((byte) 1, "待确认"),
    CONFIRMED((byte) 2, "已确认"),
    FINISH((byte) 3, "已完成"),
    CANCEL((byte) 4, "已取消"),
    ;

    EnumOrderStatus(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final byte code;
    private final String msg;

    public static EnumOrderStatus get(Byte code){
        for(EnumOrderStatus orderStatus:values()){
            if(orderStatus.getCode() == code){
                return orderStatus;
            }
        }
        return UNKNOWN;
    }

    public static boolean isConfirmed(Byte code) {
        return Objects.equals(CONFIRMED.getCode(), code) || Objects.equals(FINISH.getCode(), code);
    }

    public static List<Byte> notCancel() {
        return Arrays.asList(WAIT_CONFIRM.code, CONFIRMED.code, FINISH.code);
    }

}
