package com.youqian.api.params.page;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/13.
 */
@Data
public class AddComponentParam implements Serializable {

    private static final long serialVersionUID = -7774025392288921858L;

    /**
     * 组件名
     * max length = 50
     * not null default = null
     */
    private String componentName;

    /**
     * 组件等级 1父组件 2子组件
     * not null default = 1
     */
    private Integer componentLevel;

    /**
     * 父组件id
     * not null default = 0
     */
    private Long parentComponentId;

    /**
     * 组件设计图
     * max length = 255
     */
    private String designImgOss;

    /**
     * 组件作用页面
     */
    private List<Long> pageIds;
}
