package com.youqian.api.dto.customer.custom;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 商户客户性别分布
 * Created by hong
 * time 2020/8/18.
 */
@Data
public class CustomerGenderDto {
    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 客户人数
     */
    private Integer customersTotal;

    /**
     * 男性
     */
    private Integer    maleTotal;

    /**
     * 女性
     */
    private Integer    femaleTotal;

    /**
     * 未知
     */
    private Integer    unknownTotal;

    /**
     * 男性百分比(%)
     */
    private BigDecimal malePercentage;

    /**
     * 女性百分比(%)
     */
    private BigDecimal femalePercentage;

    /**
     * 未知百分比(%)
     */
    private BigDecimal unknownPercentage;
}
