/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.api.params.merchant;

import com.youqian.api.params.PageParam;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CustomerListParam
extends PageParam {
    private static final long serialVersionUID = -3869532044217140433L;
    private static final Pattern PHONE_REG = Pattern.compile("^[1]([3-9])[0-9]{9}$");
    private Integer sortBy = 5;
    private Integer sortType = 0;
    private String searchKey;
    private Long merchantId;
    private String searchName;
    private Byte blacklist;
    private Long userId;
    private List<Long> employeeIds;

    public void setSearchKey(String searchKey) {
        if (StringUtils.isBlank((String)searchKey)) {
            return;
        }
        if (PHONE_REG.matcher(searchKey).matches()) {
            this.searchKey = searchKey;
            return;
        }
        this.searchName = searchKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerListParam)) {
            return false;
        }
        CustomerListParam other = (CustomerListParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$sortBy = this.getSortBy();
        Integer other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)this$sortBy).equals(other$sortBy)) {
            return false;
        }
        Integer this$sortType = this.getSortType();
        Integer other$sortType = other.getSortType();
        if (this$sortType == null ? other$sortType != null : !((Object)this$sortType).equals(other$sortType)) {
            return false;
        }
        String this$searchKey = this.getSearchKey();
        String other$searchKey = other.getSearchKey();
        if (this$searchKey == null ? other$searchKey != null : !this$searchKey.equals(other$searchKey)) {
            return false;
        }
        Long this$merchantId = this.getMerchantId();
        Long other$merchantId = other.getMerchantId();
        if (this$merchantId == null ? other$merchantId != null : !((Object)this$merchantId).equals(other$merchantId)) {
            return false;
        }
        String this$searchName = this.getSearchName();
        String other$searchName = other.getSearchName();
        if (this$searchName == null ? other$searchName != null : !this$searchName.equals(other$searchName)) {
            return false;
        }
        Byte this$blacklist = this.getBlacklist();
        Byte other$blacklist = other.getBlacklist();
        if (this$blacklist == null ? other$blacklist != null : !((Object)this$blacklist).equals(other$blacklist)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        List<Long> this$employeeIds = this.getEmployeeIds();
        List<Long> other$employeeIds = other.getEmployeeIds();
        return !(this$employeeIds == null ? other$employeeIds != null : !((Object)this$employeeIds).equals(other$employeeIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CustomerListParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)$sortBy).hashCode());
        Integer $sortType = this.getSortType();
        result = result * 59 + ($sortType == null ? 43 : ((Object)$sortType).hashCode());
        String $searchKey = this.getSearchKey();
        result = result * 59 + ($searchKey == null ? 43 : $searchKey.hashCode());
        Long $merchantId = this.getMerchantId();
        result = result * 59 + ($merchantId == null ? 43 : ((Object)$merchantId).hashCode());
        String $searchName = this.getSearchName();
        result = result * 59 + ($searchName == null ? 43 : $searchName.hashCode());
        Byte $blacklist = this.getBlacklist();
        result = result * 59 + ($blacklist == null ? 43 : ((Object)$blacklist).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        List<Long> $employeeIds = this.getEmployeeIds();
        result = result * 59 + ($employeeIds == null ? 43 : ((Object)$employeeIds).hashCode());
        return result;
    }

    public Integer getSortBy() {
        return this.sortBy;
    }

    public Integer getSortType() {
        return this.sortType;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public Long getMerchantId() {
        return this.merchantId;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public Byte getBlacklist() {
        return this.blacklist;
    }

    public Long getUserId() {
        return this.userId;
    }

    public List<Long> getEmployeeIds() {
        return this.employeeIds;
    }

    public void setSortBy(Integer sortBy) {
        this.sortBy = sortBy;
    }

    public void setSortType(Integer sortType) {
        this.sortType = sortType;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public void setBlacklist(Byte blacklist) {
        this.blacklist = blacklist;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setEmployeeIds(List<Long> employeeIds) {
        this.employeeIds = employeeIds;
    }

    @Override
    public String toString() {
        return "CustomerListParam(sortBy=" + this.getSortBy() + ", sortType=" + this.getSortType() + ", searchKey=" + this.getSearchKey() + ", merchantId=" + this.getMerchantId() + ", searchName=" + this.getSearchName() + ", blacklist=" + this.getBlacklist() + ", userId=" + this.getUserId() + ", employeeIds=" + this.getEmployeeIds() + ")";
    }
}

