/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.api.params.statistics;

import cn.com.duiba.wolf.utils.DateUtils;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class PlatformStatisticsParam
implements Serializable {
    private static final long serialVersionUID = 8922706664161803713L;
    private Integer queryTimeType;
    private Long merchantId;
    @Deprecated
    private Integer year = 0;
    @Deprecated
    private Integer month = 0;
    @Deprecated
    private Integer day = 0;
    @Deprecated
    private Integer week = 0;

    public void setQueryTimeType(Integer queryTimeType) {
        Date date = new Date();
        if (Objects.equals(4, queryTimeType)) {
            this.year = this.getYears(date);
            this.month = this.getMonths(date);
            this.day = 0;
            this.week = 0;
            this.queryTimeType = queryTimeType;
        } else if (Objects.equals(2, queryTimeType)) {
            this.year = this.getYears(DateUtils.daysAddOrSub((Date)date, (int)-1));
            this.month = this.getMonths(DateUtils.daysAddOrSub((Date)date, (int)-1));
            this.day = this.getDays(DateUtils.daysAddOrSub((Date)date, (int)-1));
            this.week = this.getWeeks(DateUtils.daysAddOrSub((Date)date, (int)-1));
            this.queryTimeType = queryTimeType;
        } else if (Objects.equals(3, queryTimeType)) {
            this.year = this.getYears(date);
            this.month = 0;
            this.day = 0;
            this.week = this.getWeeks(date);
            this.queryTimeType = queryTimeType;
        } else if (Objects.equals(1, queryTimeType)) {
            this.year = this.getYears(date);
            this.month = this.getMonths(date);
            this.day = this.getDays(date);
            this.week = this.getWeeks(date);
            this.queryTimeType = queryTimeType;
        }
    }

    private int getYears(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    private int getMonths(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    private int getDays(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    private int getWeeks(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(3);
    }

    public Integer getQueryTimeType() {
        return this.queryTimeType;
    }

    public Long getMerchantId() {
        return this.merchantId;
    }

    @Deprecated
    public Integer getYear() {
        return this.year;
    }

    @Deprecated
    public Integer getMonth() {
        return this.month;
    }

    @Deprecated
    public Integer getDay() {
        return this.day;
    }

    @Deprecated
    public Integer getWeek() {
        return this.week;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    @Deprecated
    public void setYear(Integer year) {
        this.year = year;
    }

    @Deprecated
    public void setMonth(Integer month) {
        this.month = month;
    }

    @Deprecated
    public void setDay(Integer day) {
        this.day = day;
    }

    @Deprecated
    public void setWeek(Integer week) {
        this.week = week;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlatformStatisticsParam)) {
            return false;
        }
        PlatformStatisticsParam other = (PlatformStatisticsParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$queryTimeType = this.getQueryTimeType();
        Integer other$queryTimeType = other.getQueryTimeType();
        if (this$queryTimeType == null ? other$queryTimeType != null : !((Object)this$queryTimeType).equals(other$queryTimeType)) {
            return false;
        }
        Long this$merchantId = this.getMerchantId();
        Long other$merchantId = other.getMerchantId();
        if (this$merchantId == null ? other$merchantId != null : !((Object)this$merchantId).equals(other$merchantId)) {
            return false;
        }
        Integer this$year = this.getYear();
        Integer other$year = other.getYear();
        if (this$year == null ? other$year != null : !((Object)this$year).equals(other$year)) {
            return false;
        }
        Integer this$month = this.getMonth();
        Integer other$month = other.getMonth();
        if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
            return false;
        }
        Integer this$day = this.getDay();
        Integer other$day = other.getDay();
        if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
            return false;
        }
        Integer this$week = this.getWeek();
        Integer other$week = other.getWeek();
        return !(this$week == null ? other$week != null : !((Object)this$week).equals(other$week));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlatformStatisticsParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $queryTimeType = this.getQueryTimeType();
        result = result * 59 + ($queryTimeType == null ? 43 : ((Object)$queryTimeType).hashCode());
        Long $merchantId = this.getMerchantId();
        result = result * 59 + ($merchantId == null ? 43 : ((Object)$merchantId).hashCode());
        Integer $year = this.getYear();
        result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
        Integer $month = this.getMonth();
        result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
        Integer $day = this.getDay();
        result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
        Integer $week = this.getWeek();
        result = result * 59 + ($week == null ? 43 : ((Object)$week).hashCode());
        return result;
    }

    public String toString() {
        return "PlatformStatisticsParam(queryTimeType=" + this.getQueryTimeType() + ", merchantId=" + this.getMerchantId() + ", year=" + this.getYear() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ", week=" + this.getWeek() + ")";
    }
}

