package com.youqian.api.dto.accesslog;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 访问线索
 * @author youqian mybatis generator 
 * 2020-08-11
 */
@Data
public class AccessClueDto implements Serializable {
    private static final long serialVersionUID = 15971346797404631L;

    /**
     * 自增键ID
     * not null default = null
     */
    private Long id;

    /**
     * 访问线索ID
     * not null default = 0
     */
    private Long accessClueId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 客户ID
     * not null default = 0
     */
    private Long customerId;

    /**
     * 是否存在关键动作
     * not null default = 0
     */
    private Byte hasAction;

    /**
     * 请求token时间戳
     * not null default = 0
     */
    private Long timeStamp;

    /**
     * 用来排序的时间
     */
    private Date visitDate;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}