package com.youqian.api.dto.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 意向客户表
 * @author youqian mybatis generator 
 * 2020-12-29
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CustomerIntentDto implements Serializable {
    private static final long serialVersionUID = 16092088805612865L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 意向客户ID
     * not null default = 0
     */
    private Long customerIntentId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 直播名称
     * max length = 20
     * not null default = 
     */
    private String roomName;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 直播开始时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date liveEndTime;

    /**
     * 删除状态
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}