package com.youqian.api.dto.customer;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 卖家报价
 * @author youqian mybatis generator 
 * 2021-01-06
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CustomerIntentItemDto implements Serializable {
    private static final long serialVersionUID = 1609919835671309L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 客户报价ID
     * not null default = 0
     */
    private Long customerIntentItemId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 商品ID
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 商品价格
     * not null default = 0.00
     */
    private BigDecimal goodsPrice;

    /**
     * 删除状态
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}