package com.youqian.api.dto.dunningbill.custom;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 回款单dto
 * Created by hong
 * time 2020/4/13.
 */
@Data
public class DunningOrderDto implements Serializable {

    private static final long serialVersionUID = 7350303840301743557L;

    /**
     * 订单ID
     * not null default = 0
     */
    private Long orderId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 订单创建人
     * not null default = 0
     */
    private Long createUserId;

    /**
     * 开单人姓名
     * max length = 64
     * not null default =
     */
    private String createUserName;

    /**
     * 开单人账号
     * max length = 64
     * not null default =
     */
    private String createAccount;

    /**
     * 客户ID
     * not null default = 0
     */
    private Long customerId;

    /**
     * 客户主体ID
     * not null default = 0
     */
    private Long customerSignEntityId;

    /**
     * 客户UserId
     * not null default = 0
     */
    private Long customerUserId;

    /**
     * 客户手机号
     * max length = 20
     * not null default =
     */
    private String customerMobile;

    /**
     * 客户经办人名称
     * max length = 20
     * not null default =
     */
    private String customerName;

    /**
     * 客户企业名称
     * max length = 20
     * not null default =
     */
    private String customerEnterpriseName;

    /**
     * 商品总额
     * not null default = 0.00
     */
    private BigDecimal goodsPrice;

    /**
     * （原价）订单总额=商品总额+运费+税费等等
     * not null default = 0.00
     */
    private BigDecimal originOrderPrice;

    /**
     * 订单总额折后价
     * not null default = 0.00
     */
    private BigDecimal orderPrice;

    /**
     * 订单优惠价格（优惠了多少价格）
     * not null default = 0.00
     */
    private BigDecimal reducePrice;

    /**
     * 已收款金额
     */
    private BigDecimal receivePrice;

    /**
     * 待收款金额
     * not null default = 0.00
     */
    private BigDecimal restPrice;

    /**
     * 订单状态,0-草稿，1-待确认，2-已确认，3-已完成
     * not null default = 0
     */
    private Byte orderStatus;

    /**
     * 发货状态，0-未发货，1-已发货
     * not null default = 0
     */
    private Byte deliverGoods;

    /**
     * 收款状态，0-未收款，1-收款完成
     * not null default = 0
     */
    private Byte moneyReceiveType;

    /**
     * 订单确认时间
     */
    private Date confirmTime;

    /**
     * 发货时间（操作发票时间）
     */
    private Date deliveryTime;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 距离订单确认(天数)
     */
    private String distanceOrderConfirmation;

    /**
     * 距离商品发货(天数)
     */
    private String distanceGoodsDelivery;

    /**
     * 订单标题
     */
    private String title;
}
