package com.youqian.api.dto.homeConfig;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 首页配置表
 * @author youqian mybatis generator 
 * 2021-01-15
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HomeConfigDto implements Serializable {
    private static final long serialVersionUID = 16106920355046918L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long homeConfigId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 默认配置
     * not null default = null
     */
    private Byte defaultConfig;
}